
<?php
/*
function is_logged_in(): bool {
  return !empty($_SESSION['user_id']);
}

function require_login() {
  if (!is_logged_in()) {
    header("Location: /auth/login.php");
    exit;
  }
}

function e($str) {
  return htmlspecialchars($str ?? '', ENT_QUOTES, 'UTF-8');
}

function redirect($path) {
  header("Location: $path");
  exit;
}

function stars_html($rating): string {
  $full = floor($rating);
  $half = ($rating - $full) >= 0.5 ? 1 : 0;
  $empty = 5 - $full - $half;

  $html = '';
  for ($i=0; $i<$full; $i++) $html .= '<span class="star">★</span>';
  if ($half) $html .= '<span class="star half">★</span>';
  for ($i=0; $i<$empty; $i++) $html .= '<span class="star empty">★</span>';
  return $html;
}


function product_image($url) {
  if (preg_match('/^https?:\/\//i', $url)) {
    // External image (Google, Unsplash, etc.)
    return $url;
  }
  // Local image
  return '/myukstore/' . ltrim($url, '/');
}
*/


function e($s){ return htmlspecialchars($s); }

function is_logged_in(){
  return isset($_SESSION['user_id']);
}

function require_login(){
  if(!is_logged_in()){
    header("Location: /myukstore/auth/login.php");
    exit;
  }
}

function product_image($path) {
    if (!$path) {
        return "/myukstore/img/no-image.png"; // optional fallback
    }
    return "/myukstore/" . ltrim($path, '/');
}




function stars_html($r){
  $out='';
  for($i=1;$i<=5;$i++){
    $out .= $i <= round($r) ? '⭐' : '☆';
  }
  return $out;
}

