<?php
require_once __DIR__ . "/config.php";
require_once __DIR__ . "/functions.php";

/*
  Detect auth pages
*/
$currentPage = basename($_SERVER['PHP_SELF']);
$authPages = ['login.php', 'signup.php', 'forgot.php'];
$isAuthPage = in_array($currentPage, $authPages);
?>
<!doctype html>
<html lang="en">
<head>
  <meta charset="utf-8"/>
  <meta name="viewport" content="width=device-width,initial-scale=1"/>
  <title>My UK Store</title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
  <link rel="stylesheet" href="/myukstore/assets/css/style.css">
</head>
<body>

<nav class="navbar navbar-expand-lg navbar-dark bg-dark">
  <div class="container">

    <!-- LOGO -->
    <a class="navbar-brand fw-bold" href="/myukstore/index.php">ZONEXA</a>

    <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#nav">
      <span class="navbar-toggler-icon"></span>
    </button>

    <div id="nav" class="collapse navbar-collapse">

      <!-- ✅ LEFT MENU (ONLY: logged in + NOT auth pages) -->
      <?php if (is_logged_in() && !$isAuthPage): ?>
        <ul class="navbar-nav me-auto">
          <li class="nav-item"><a class="nav-link" href="/myukstore/index.php">Home</a></li>
          <li class="nav-item"><a class="nav-link" href="/myukstore/category.php?c=kitchen">Kitchen</a></li>
          <li class="nav-item"><a class="nav-link" href="/myukstore/category.php?c=household">HouseHold</a></li>
          <li class="nav-item"><a class="nav-link" href="/myukstore/category.php?c=beauty">Beauty</a></li>
          <li class="nav-item"><a class="nav-link" href="/myukstore/category.php?c=pets">Pets</a></li>
          <li class="nav-item"><a class="nav-link" href="/myukstore/contact.php">Contact</a></li>
        </ul>
      <?php endif; ?>

      <!-- RIGHT SIDE -->
      <ul class="navbar-nav ms-auto">

        <?php if (is_logged_in()): ?>
          <li class="nav-item">
            <span class="navbar-text me-3 text-white">
              Hi, <?= e($_SESSION['user_name']) ?>
            </span>
          </li>
          <li class="nav-item">
            <a class="btn btn-outline-light btn-sm" href="/myukstore/auth/logout.php">Logout</a>
          </li>
        <?php else: ?>
          <li class="nav-item">
            <a class="btn btn-outline-light btn-sm me-2" href="/myukstore/auth/login.php">Login</a>
          </li>
          <li class="nav-item">
            <a class="btn btn-warning btn-sm" href="/myukstore/auth/signup.php">Signup</a>
          </li>
        <?php endif; ?>

      </ul>
    </div>
  </div>
</nav>

<main class="container my-4">
