<?php
require_once "includes/config.php";
require_once "includes/functions.php";
include "includes/header.php";

$items = $pdo->query("
  SELECT * FROM products ORDER BY RAND() LIMIT 28
")->fetchAll();
?>

<!-- Hero Banner -->
<div class="hero fade-in-up mb-5">
  <div class="container">
    <h1 class="display-3 fw-bold mb-3" style="color: white !important; text-shadow: 2px 2px 8px rgba(0,0,0,0.3);">
      <i class="bi bi-shop me-3"></i>Welcome to ZONEXA
    </h1>
    <p class="lead fs-4" style="color: white !important; text-shadow: 1px 1px 4px rgba(0,0,0,0.2);">
      Premium UK Products Delivered to Your Doorstep
    </p>
    
    <?php if (!is_logged_in()): ?>
      <a href="/myukstore/auth/signup.php" class="btn btn-warning btn-lg pulse shadow-lg" style="font-weight: 600;">
        Start Shopping Now
      </a>
    <?php endif; ?>
  </div>
</div>

<!-- Category Quick Links -->
<?php if (is_logged_in()): ?>
<div class="row g-3 mb-5">
  <div class="col-md-3">
    <a href="/myukstore/category.php?c=kitchen" class="text-decoration-none">
      <div class="card h-100 text-center py-4 category-card">
        <i class="bi bi-cup-hot fs-1 text-primary mb-3"></i>
        <h5 class="mb-0">Kitchen</h5>
      </div>
    </a>
  </div>
  <div class="col-md-3">
    <a href="/myukstore/category.php?c=household" class="text-decoration-none">
      <div class="card h-100 text-center py-4 category-card">
        <i class="bi bi-house-door fs-1 text-success mb-3"></i>
        <h5 class="mb-0">Household</h5>
      </div>
    </a>
  </div>
  <div class="col-md-3">
    <a href="/myukstore/category.php?c=beauty" class="text-decoration-none">
      <div class="card h-100 text-center py-4 category-card">
        <i class="bi bi-stars fs-1 text-danger mb-3"></i>
        <h5 class="mb-0">Beauty</h5>
      </div>
    </a>
  </div>
  <div class="col-md-3">
    <a href="/myukstore/category.php?c=pets" class="text-decoration-none">
      <div class="card h-100 text-center py-4 category-card">
        <i class="bi bi-heart fs-1 text-warning mb-3"></i>
        <h5 class="mb-0">Pets</h5>
      </div>
    </a>
  </div>
</div>

<style>
.category-card {
  transition: all 0.3s ease;
  cursor: pointer;
}
.category-card:hover {
  transform: translateY(-8px);
  box-shadow: 0 8px 32px rgba(0,0,0,0.16);
}
</style>
<?php endif; ?>

<!-- Products Section -->
<div class="d-flex justify-content-between align-items-center mb-4">
  <h2 class="mb-0">
    <i class="bi bi-basket2 me-2"></i>Featured Products
  </h2>
  <?php if (is_logged_in()): ?>
    <a href="/myukstore/cart.php" class="btn btn-dark">
      <i class="bi bi-cart3 me-2"></i>View Cart
      <?php if (!empty($_SESSION['cart'])): ?>
        <span class="badge bg-danger"><?= count($_SESSION['cart']) ?></span>
      <?php endif; ?>
    </a>
  <?php endif; ?>
</div>

<div class="row g-4">
<?php foreach($items as $p): ?>
  <div class="col-lg-3 col-md-4 col-sm-6">
    <div class="card product-card h-100 fade-in-up">

      <!-- Product Image -->
      <div class="position-relative">
        <img src="<?= product_image($p['image_url']) ?>"
             class="card-img-top"
             style="height:200px;object-fit:cover;"
             alt="<?= e($p['title']) ?>">
        
        <!-- Stock Badge -->
        <?php if ($p['stock'] <= 0): ?>
          <span class="position-absolute top-0 end-0 m-2 stock-badge out-of-stock">
            Out of Stock
          </span>
        <?php elseif ($p['stock'] <= 5): ?>
          <span class="position-absolute top-0 end-0 m-2 stock-badge low-stock">
            Only <?= $p['stock'] ?> left
          </span>
        <?php endif; ?>
      </div>

      <div class="card-body d-flex flex-column">
        <!-- Product Title -->
        <h6 class="card-title"><?= e($p['title']) ?></h6>

        <!-- Rating -->
        <div class="rating mb-2">
          <?= stars_html($p['rating']) ?>
          <span class="small text-muted ms-1">(<?= e($p['rating']) ?>)</span>
        </div>

        <!-- Price -->
        <p class="fw-bold fs-5 mb-3 price-tag">£<?= e($p['price']) ?></p>

        <!-- Actions -->
        <?php if ($p['stock'] > 0): ?>
          <form action="/myukstore/cart_add.php" method="post" class="mt-auto">
            <input type="hidden" name="id" value="<?= (int)$p['id'] ?>">

            <!-- Quantity Selector -->
            <div class="mb-2">
              <label class="form-label small">Quantity:</label>
              <select name="qty" class="form-select form-select-sm">
                <?php for($i=1; $i<=min(15, $p['stock']); $i++): ?>
                  <option value="<?= $i ?>"><?= $i ?></option>
                <?php endfor; ?>
              </select>
            </div>

            <!-- Add to Cart Button -->
            <button class="btn btn-dark btn-sm w-100 mb-2">
              <i class="bi bi-cart-plus me-1"></i>Add to Cart
            </button>
          </form>
        <?php else: ?>
          <button class="btn btn-secondary btn-sm w-100 mb-2" disabled>
            <i class="bi bi-x-circle me-1"></i>Out of Stock
          </button>
        <?php endif; ?>

        <!-- View Details Button -->
        <a href="/myukstore/product.php?id=<?= (int)$p['id'] ?>"
           class="btn btn-outline-dark btn-sm w-100">
          <i class="bi bi-eye me-1"></i>View Details
        </a>

      </div>
    </div>
  </div>
<?php endforeach; ?>
</div>

<!-- Trust Badges -->
<div class="row g-4 mt-5 mb-5">
  <div class="col-md-3 text-center">
    <div class="card p-4 h-100">
      <i class="bi bi-truck fs-1 text-primary mb-3"></i>
      <h5>Free UK Delivery</h5>
      <p class="text-muted small mb-0">On orders over £30</p>
    </div>
  </div>
  <div class="col-md-3 text-center">
    <div class="card p-4 h-100">
      <i class="bi bi-shield-check fs-1 text-success mb-3"></i>
      <h5>Secure Payment</h5>
      <p class="text-muted small mb-0">SSL encrypted transactions</p>
    </div>
  </div>
  <div class="col-md-3 text-center">
    <div class="card p-4 h-100">
      <i class="bi bi-arrow-clockwise fs-1 text-warning mb-3"></i>
      <h5>Easy Returns</h5>
      <p class="text-muted small mb-0">30-day money back guarantee</p>
    </div>
  </div>
  <div class="col-md-3 text-center">
    <div class="card p-4 h-100">
      <i class="bi bi-headset fs-1 text-info mb-3"></i>
      <h5>24/7 Support</h5>
      <p class="text-muted small mb-0">Dedicated customer service</p>
    </div>
  </div>
</div>

<?php include "includes/footer.php"; ?>