<?php
require_once "includes/config.php";
require_once "includes/functions.php";

$id = (int)($_GET['id'] ?? 0);

$stmt = $pdo->prepare("SELECT p.*, c.name as category_name, c.slug as category_slug 
                       FROM products p 
                       LEFT JOIN categories c ON p.category_id = c.id 
                       WHERE p.id=? LIMIT 1");
$stmt->execute([$id]);
$p = $stmt->fetch();

if (!$p) {
  header("Location: /myukstore/index.php");
  exit;
}

include "includes/header.php";
?>

<div class="fade-in-up">
  <!-- Breadcrumb -->
  <nav aria-label="breadcrumb" class="mb-4">
    <ol class="breadcrumb">
      <li class="breadcrumb-item"><a href="/myukstore/index.php">Home</a></li>
      <li class="breadcrumb-item">
        <a href="/myukstore/category.php?c=<?= e($p['category_slug']) ?>">
          <?= e($p['category_name']) ?>
        </a>
      </li>
      <li class="breadcrumb-item active"><?= e($p['title']) ?></li>
    </ol>
  </nav>

  <div class="row g-5">
    <!-- Product Image -->
    <div class="col-md-6">
      <div class="product-image-container">
        <img src="<?= product_image($p['image_url']) ?>" 
             class="img-fluid rounded product-detail-img" 
             alt="<?= e($p['title']) ?>">
        
        <!-- Stock Badge on Image -->
        <?php if ($p['stock'] <= 0): ?>
          <div class="position-absolute top-0 start-0 m-3">
            <span class="stock-badge out-of-stock fs-6 px-3 py-2">
              <i class="bi bi-x-circle me-2"></i>Out of Stock
            </span>
          </div>
        <?php elseif ($p['stock'] <= 5): ?>
          <div class="position-absolute top-0 start-0 m-3">
            <span class="stock-badge low-stock fs-6 px-3 py-2">
              <i class="bi bi-exclamation-triangle me-2"></i>Only <?= $p['stock'] ?> left
            </span>
          </div>
        <?php else: ?>
          <div class="position-absolute top-0 start-0 m-3">
            <span class="stock-badge in-stock fs-6 px-3 py-2">
              <i class="bi bi-check-circle me-2"></i>In Stock
            </span>
          </div>
        <?php endif; ?>
      </div>
    </div>

    <!-- Product Details -->
    <div class="col-md-6">
      <div class="product-details">
        
        <!-- Category Badge -->
        <span class="badge bg-secondary mb-3">
          <i class="bi bi-tag me-1"></i><?= e($p['category_name']) ?>
        </span>

        <!-- Product Title -->
        <h1 class="display-5 fw-bold mb-3"><?= e($p['title']) ?></h1>

        <!-- Rating -->
        <div class="rating mb-3">
          <?= stars_html($p['rating']) ?>
          <span class="ms-2 text-muted"><?= e($p['rating']) ?> out of 5</span>
        </div>

        <!-- Price -->
        <h2 class="price-tag mb-4">
          £<?= number_format($p['price'], 2) ?>
        </h2>

        <!-- Short Description -->
        <?php if (!empty($p['short_description'])): ?>
          <p class="lead text-muted mb-4">
            <?= e($p['short_description']) ?>
          </p>
        <?php endif; ?>

        <!-- Add to Cart Form -->
        <?php if ($p['stock'] > 0): ?>
          <div class="card p-4 mb-4 bg-light">
            <form action="/myukstore/cart_add.php" method="post">
              <input type="hidden" name="id" value="<?= (int)$p['id'] ?>">

              <div class="row g-3 align-items-end">
                <div class="col-md-4">
                  <label class="form-label fw-bold">Quantity</label>
                  <select name="qty" class="form-select form-select-lg">
                    <?php for ($i=1; $i<=min(15,$p['stock']); $i++): ?>
                      <option value="<?= $i ?>"><?= $i ?></option>
                    <?php endfor; ?>
                  </select>
                </div>

                <div class="col-md-8">
                  <button type="submit" class="btn btn-dark btn-lg w-100">
                    <i class="bi bi-cart-plus me-2"></i>
                    Add to Cart
                  </button>
                </div>
              </div>
            </form>
          </div>
        <?php else: ?>
          <div class="alert alert-warning">
            <i class="bi bi-exclamation-triangle me-2"></i>
            <strong>Currently Out of Stock</strong><br>
            <small>This item will be restocked soon. Please check back later.</small>
          </div>
        <?php endif; ?>

        <!-- Product Features -->
        <div class="row g-3 mb-4">
          <div class="col-6">
            <div class="d-flex align-items-center">
              <i class="bi bi-truck text-primary fs-4 me-3"></i>
              <div>
                <strong>Free Delivery</strong><br>
                <small class="text-muted">On orders £30+</small>
              </div>
            </div>
          </div>
          <div class="col-6">
            <div class="d-flex align-items-center">
              <i class="bi bi-shield-check text-success fs-4 me-3"></i>
              <div>
                <strong>Secure Payment</strong><br>
                <small class="text-muted">SSL Protected</small>
              </div>
            </div>
          </div>
          <div class="col-6">
            <div class="d-flex align-items-center">
              <i class="bi bi-arrow-clockwise text-warning fs-4 me-3"></i>
              <div>
                <strong>Easy Returns</strong><br>
                <small class="text-muted">30 days guarantee</small>
              </div>
            </div>
          </div>
          <div class="col-6">
            <div class="d-flex align-items-center">
              <i class="bi bi-headset text-info fs-4 me-3"></i>
              <div>
                <strong>Support 24/7</strong><br>
                <small class="text-muted">Always available</small>
              </div>
            </div>
          </div>
        </div>

      </div>
    </div>
  </div>

  <!-- Product Description Section -->
  <?php if (!empty($p['description'])): ?>
    <div class="row mt-5">
      <div class="col-12">
        <div class="card">
          <div class="card-header bg-dark text-white">
            <h4 class="mb-0"><i class="bi bi-info-circle me-2"></i>Product Description</h4>
          </div>
          <div class="card-body p-4">
            <p class="mb-0" style="white-space: pre-line;"><?= nl2br(e($p['description'])) ?></p>
          </div>
        </div>
      </div>
    </div>
  <?php endif; ?>

  <!-- Related Products -->
  <?php
  $relatedStmt = $pdo->prepare("SELECT * FROM products 
                                 WHERE category_id = ? AND id != ? 
                                 ORDER BY RAND() LIMIT 4");
  $relatedStmt->execute([$p['category_id'], $id]);
  $relatedProducts = $relatedStmt->fetchAll();
  
  if (!empty($relatedProducts)):
  ?>
    <div class="row mt-5">
      <div class="col-12">
        <h3 class="mb-4">
          <i class="bi bi-grid me-2"></i>You May Also Like
        </h3>
      </div>
      
      <?php foreach ($relatedProducts as $rp): ?>
        <div class="col-md-3">
          <div class="card product-card h-100">
            <img src="<?= product_image($rp['image_url']) ?>" 
                 class="card-img-top" 
                 style="height:180px;object-fit:cover;"
                 alt="<?= e($rp['title']) ?>">
            <div class="card-body">
              <h6><?= e($rp['title']) ?></h6>
              <div class="rating mb-2">
                <?= stars_html($rp['rating']) ?>
              </div>
              <p class="fw-bold mb-2">£<?= e($rp['price']) ?></p>
              <a href="/myukstore/product.php?id=<?= (int)$rp['id'] ?>" 
                 class="btn btn-outline-dark btn-sm w-100">
                View Details
              </a>
            </div>
          </div>
        </div>
      <?php endforeach; ?>
    </div>
  <?php endif; ?>

</div>

<style>
.product-image-container {
  position: relative;
}

.breadcrumb {
  background: white;
  padding: 1rem;
  border-radius: 8px;
  box-shadow: 0 2px 8px rgba(0,0,0,0.08);
}

.breadcrumb-item + .breadcrumb-item::before {
  content: "›";
  font-size: 1.2rem;
}
</style>

<?php include "includes/footer.php"; ?>